﻿/*
 * Unite 2013: Custom Build Processes with Unity3D
 * =======================================================
 * Author: William Roberts - http://www.williamroberts.net
 * Date:   August 27, 2013
 * 
 * Schell Games - http://www.schellgames.com
 */

using System;
using UniteExample.Framework;

namespace UniteExample.Application
{
    class Program
    {
        // Forward slashes are used to ensure the path is cross platform.
        private const string ExampleProjectFile = "../../ExampleProject/DemoProject.build";

        // Note that the Microsoft.Build.BuildEngine.Engine objects requires the executing thread to 
        // run in 'single-threaded apartment' mode.
        [STAThread]
        static void Main(string[] args)
        {
            BuildEngine engine = null;

            try
            {
                string projectFile;

                if (args.Length == 0)
                    projectFile = ExampleProjectFile;
                else
                    projectFile = args[0];

                engine = new BuildEngine();
                engine.Execute(projectFile);
            }
            catch (Exception ex)
            {
                Console.ForegroundColor = ConsoleColor.Red;
                Console.WriteLine("Build failed due to an unexpected exception!");
                Console.WriteLine(ex.ToString());
                Console.ResetColor();
            }
            finally
            {
                if (engine != null)
                    engine.Dispose();
            }
        }
    }
}
