/*
 * Unite 2013: Custom Build Processes with Unity3D
 * =======================================================
 * Author: William Roberts - http://www.williamroberts.net
 * Date:   August 27, 2013
 * 
 * Schell Games - http://www.schellgames.com
 */

using System;
using System.IO;
using System.Net;
using System.Net.Sockets;

public class NetworkLogManager : IDisposable
{
	private const int DefaultPort = 21000;
	
	private static TcpClient _client;
	private static BinaryWriter _writer;
	
	public NetworkLogManager ()
	{
		_client = new TcpClient();
		_client.Connect(IPAddress.Loopback, DefaultPort);

        _writer = new BinaryWriter(_client.GetStream());
	}
	
	public void LogMessage(string message)
	{
		_writer.Write(message);	
	}
	
	public void Dispose()
	{
		if (_writer != null)
		{
			_writer.Close();
			_writer = null;
		}
		
		if (_client != null)
		{
			_client.Close();
			_client = null;
		}	
	}
}
