/*
 * Unite 2013: Custom Build Processes with Unity3D
 * =======================================================
 * Author: William Roberts - http://www.williamroberts.net
 * Date:   August 27, 2013
 * 
 * Schell Games - http://www.schellgames.com
 */

using System;
using UnityEngine;

public static class ClientBuildEngine
{
	public static void Build()
	{
		string buildTarget;
		
		using(NetworkLogManager logManager = new NetworkLogManager())
		{		
            //Note: The SimpleExample object is defined in Lib\SimpleExample.dll. This assembly is
            //      copied over during the build process.

			logManager.LogMessage("Hello from Unity!");
			logManager.LogMessage(SimpleExample.Test.GetMessage());
			
			if(GetBuildTarget(out buildTarget))
			{
				logManager.LogMessage("Building with target: " + buildTarget);
			}

            // TODO: Physically build the Unity Player using the UnityEditor.BuildPipeline object. This code was
            //       omitted to simplify the example. For more information about BuildPipeline, see:
            //       http://docs.unity3d.com/Documentation/ScriptReference/BuildPipeline.html
		}
	}
	
	private static bool GetBuildTarget(out string buildTarget)
	{
		buildTarget = string.Empty;
		string[] args = Environment.GetCommandLineArgs();
		
		for (int i = 0; i < args.Length; i++)
        {
			if(args[i] == "-buildTarget")
			{
				if(i+1 >=  args.Length)
					return false;
				
				buildTarget = args[i+1];
				return true;
			}
		}
		
		return false;
	}
}
